<?php

namespace Inside\Form\Http\Middlewares;

use Closure;
use Illuminate\Http\Request;
use Inside\Content\Models\Contents\Forms;
use Inside\Permission\Facades\Permission;
use Symfony\Component\HttpFoundation\Response;

class ContentFormMiddleware
{
    /**
     * @param Request $request
     * @param Closure                 $next
     *
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $path = $request->path();

        if (strpos($path, 'api/v1/content/forms') === 0 && in_array($request->getMethod(), ['POST', 'PUT'])
            && $request->has('admin_roles')
        ) {
            $input = $request->all();
            $input['admin_roles'] = json_encode($input['admin_roles']);

            $request->replace($input);

            return $next($request);
        }
        $response = $next($request);

        if (strpos($path, 'api/v1/form/forms') === false) {
            return $response;
        }

        $data = json_decode_response($response);
        if ($response instanceof Response && $response->getStatusCode() != 200) {
            return $response;
        }

        $adminRolesFieldsetLabel = [];
        foreach (list_languages() as $locale) {
            $adminRolesFieldsetLabel[$locale] = trans('forms.fieldsets.admin_roles', [], $locale);
        }

        $result = [
            'id'      => 'group_admin_roles',
            'weight'  => 50,
            'type'    => 'fieldset',
            'classes' => '',
            'label'   => $adminRolesFieldsetLabel,
            'fields'  => [],
        ];
        $route = $request->route();
        $content = null;
        if (isset($route[2]['id'])) {
            $content = Forms::findOrFail($route[2]['id']);
        }

        $result['fields'][] = Permission::getRolePickerFieldForFrontForm(
            'admin_roles',
            'forms.fields.roles',
            $content,
            [],
            51
        );

        $data['data'][] = $result;
        set_response($response, $data);

        return $response;
    }
}
