<?php

namespace Inside\Form\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;
use Inside\Form\Models\FormSubmission;

class BaseFormEvent implements ShouldBroadcast
{
    use InteractsWithSockets;

    /**
     * The submission
     *
     * @var FormSubmission
     */
    public $submission;

    /**
     * @var \Illuminate\Contracts\Auth\Authenticatable|null
     */
    public $user;

    /**
     * @param FormSubmission $submission
     */
    public function __construct(FormSubmission $submission)
    {
        $this->submission = $submission;
        $this->user = Auth::user();
    }

    /**
     * Get the channels the event should broadcast on.
     */
    public function broadcastOn()
    {
        return new Channel('inside.form');
    }
}
