<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Form\Models\FormAnswer;

class SaveDateAnswersAsTimestamps extends Migration
{
    public function up(): void
    {
        FormAnswer::where('field_type', 'input-date')
            ->each(function (FormAnswer $answer) {
                if (is_string($answer->answer) && ! empty($answer->answer)) {
                    $answer->update(['answer' => strtotime($answer->answer)]);
                }
            });
    }
}
