<?php

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Forms;
use Inside\Form\Models\FormAnswer;

class SaveAnswersFieldType extends Migration
{
    public function up(): void
    {
        Forms::each(function ($form) {
            $inputs = collect(json_decode($form->inputs, true))->pluck('field_type', 'field_id');

            FormAnswer::query()
                ->whereHas('submission', fn (Builder $query) => $query->where('answerable_uuid', $form->uuid))
                ->whereIn('field_id', $inputs->keys())
                ->each(function (FormAnswer $answer) use ($inputs) {
                    $answer->update(['field_type' => $inputs->get($answer->field_id)]);
                });
        });
    }
}
