<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Layout\Models\LayoutPath;
use Inside\Layout\Repositories\Contracts\LayoutRepositoryInterface;

class DeleteOldFormsLayouts extends Migration
{
    public function up(): void
    {
        /** @var LayoutRepositoryInterface $layoutRepository */
        $layoutRepository = app(LayoutRepositoryInterface::class);
        LayoutPath::where('path', 'like', 'inside_content_forms%')
            ->pluck('layout_id')
            ->unique()
            ->each(fn (int $layoutId) => $layoutRepository->delete($layoutId));
    }
}
