<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSubmissionEditInformations extends Migration
{
    public function up(): void
    {
        if (Schema::hasColumns('inside_forms_submissions', ['edited_at', 'editor_uuid'])) {
            return;
        }

        Schema::table('inside_forms_submissions', function (Blueprint $table) {
            $table->timestamp('edited_at')->nullable();
            $table->uuid('editor_uuid')->nullable();
        });
    }

    public function down(): void
    {
        if (! Schema::hasColumns('inside_forms_submissions', ['edited_at', 'editor_uuid'])) {
            return;
        }

        Schema::table('inside_forms_submissions', function (Blueprint $table) {
            $table->dropColumn(['edited_at', 'editor_uuid']);
        });
    }
}
