<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Forms;
use Inside\Form\Models\FormSubmission;

class CleanAnswersWithDeletedContentReferences extends Migration
{
    public function up(): void
    {
        $forms = Forms::query()->get();

        foreach ($forms as $form) {
            $fields = json_decode($form->inputs);

            if (! is_array($fields)) {
                continue;
            }

            foreach ($fields as $field) {
                if (! isset($field->field_select_type)) {
                    continue;
                }

                if ($field->field_select_type !== 'content') {
                    continue;
                }

                if (empty($field->field_content_type)) {
                    continue;
                }

                $submissions = FormSubmission::where('answerable_uuid', $form->uuid)->orderBy('created_at', 'DESC')->get();

                foreach ($submissions as $submission) {
                    foreach ($submission->answers as $submissionAnswer) {
                        if ($submissionAnswer->field_id !== $field->field_id) {
                            continue;
                        }

                        $query = call_user_func(type_to_class($field->field_content_type).'::query');

                        $content = $query->find($submissionAnswer->answer);

                        if ($content) {
                            continue;
                        }

                        $submissionAnswer->answer = null;
                        $submissionAnswer->save();
                    }
                }
            }
        }
    }
}
