<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddStatusNotificationsEmail extends Migration
{
    public function up(): void
    {
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdated',
                'type' => 'system',
                'condition' => 'status:1',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data'     => [
                    'mail'        => [
                        'subject'    => 'notifications.form.submission.accepted.email.subject',
                        'text'       => 'notifications.form.submission.accepted.email.text',
                        'buttonText' => 'notifications.form.submission.buttonText',
                    ],
                    'fields'      => [
                        'title',
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdated',
                'type' => 'system',
                'condition' => 'status:0',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data'     => [
                    'mail'        => [
                        'subject'    => 'notifications.form.submission.refused.email.subject',
                        'text'       => 'notifications.form.submission.refused.email.text',
                        'buttonText' => 'notifications.form.submission.buttonText',
                    ],
                    'fields'      => [
                        'title',
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdated',
                'type' => 'system',
                'condition' => 'status:2',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data'     => [
                    'mail'        => [
                        'subject'    => 'notifications.form.submission.pending.email.subject',
                        'text'       => 'notifications.form.submission.pending.email.text',
                        'buttonText' => 'notifications.form.submission.buttonText',
                    ],
                    'fields'      => [
                        'title',
                    ],
                ],
            ]
        );
    }
}
