<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddSubmissionWebNotification extends Migration
{
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'      => 'web',
                'type'     => 'system',
                'default'  => true,
                'event'    => 'Inside\Form\Events\FormSubmitedEvent',
                'model'    => 'Inside\Form\Models\FormSubmission',
                'action'   => 'submit',
                'multiple' => false,
                'language' => false,
                'profile'  => false,
                'data'     => [
                    'title'       => 'notifications.submit.form.title',
                    'description' => 'notifications.submit.form.description',
                    'text'        => 'notifications.submit.form.text',
                ],
            ]
        );
    }
}
