<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class RecreateAdminRolesFieldIfNeeded extends Migration
{
    public function up(): void
    {
        if (Schema::hasField('forms', 'admin_roles')) {
            return;
        }

        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('forms', 'admin_roles', [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'admin_roles',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 16,
            'hidden'              => true,
            'default'             => '[]',
            'title'               => [
                'fr' => 'Administrateurs',
                'en' => 'Administrators',
            ],
            'description'         => [
                'fr' => 'La liste des administrateurs',
                'en' => 'Admin list',
            ],
            'widget'              => [
                'hidden' => true,
            ],
        ]);
    }
}
