<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Forms;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class DeleteOldIntroductionFieldInForms extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();
        $forms = Forms::all();
        $intros = [];
        if (Schema::hasField('forms', 'introduction')) {
            foreach ($forms as $form) {
                $intros[] = [
                    'uuid' => $form->uuid,
                    'title' => $form->title,
                    'intro' => $form->introduction,
                ];
            }
            $bridge->contentTypeDeleteField('node', 'forms', 'introduction');
        }
        if (! Schema::hasField('forms', 'forms_introduction')) {
            $bridge->contentTypeCreateField('forms', 'forms_introduction', [
                'type'                => BridgeContentType::TEXTAREA_FIELD,
                'name'                => 'forms_introduction',
                'searchable'          => false,
                'translatable'        => (count(list_languages()) > 1),
                'search_result_field' => false,
                'required'            => false,
                'weight'              => 2,
                'default'             => null,
                'title'               => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                ],
                'description'         => [
                    'fr' => 'Ce paragraphe vous permet de présenter le sondage ou le formulaire',
                    'en' => 'This paragraph allows you to introduce the survey or form',
                ],
                'settings'            => [],
                'widget'              => [
                    'type'     => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [],
                ],
            ], 2);
        }

        foreach ($intros as $content) {
            $bridgeContent->contentUpdate('forms', [
                'uuid' => $content['uuid'],
                'bundle' => 'forms',
                'type' => 'node',
                'title' => $content['title'],
                'forms_introduction' => $content['intro'],
            ]);
        }
    }
}
