<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddStatusNotifications extends Migration
{
    public function up(): void
    {
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdated',
                'type' => 'global',
                'condition' => 'status:1',
                'multiple' => true,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'text' => 'notifications.form.submission.accepted.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdated',
                'type' => 'global',
                'condition' => 'status:0',
                'multiple' => true,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'text' => 'notifications.form.submission.refused.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdated',
                'type' => 'global',
                'condition' => 'status:2',
                'multiple' => true,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'text' => 'notifications.form.submission.pending.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );
    }
}
