<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => (count(list_languages()) > 1),
        'searchable'        => false,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => false,
        'name'              => 'forms',
        'title'             => [
            'fr' => 'Formulaires & sondages',
            'en' => 'Forms & surveys',
            'es' => 'Formularios y encuestas',
            'pt' => 'Formulários e pesquisas',
            'de' => 'Formulare und Umfragen',
            'nl' => 'Formulieren en enquêtes',
        ],
    ],
    'fields'  => [
        // Type de formulaire (Formulaire / Sondage)
        [
            'type'                => BridgeContentType::LIST_STRING_FIELD,
            'name'                => 'form_type',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'default'             => 'forms',
            'weight'              => $weight,
            'title'               => [
                'fr' => 'Quel type de contenu souhaitez-vous créer ? (case à cocher)',
                'en' => 'What type of content would you like to create? (check box)',
                'es' => '¿Qué tipo de contenido te gustaría crear? (casilla de verificación)',
                'pt' => 'Que tipo de conteúdo você gostaria de criar? (caixa de seleção)',
                'de' => 'Welchen Inhalt möchten Sie erstellen? (Kontrollkästchen)',
                'nl' => 'Wat voor soort inhoud wilt u maken? (selectievakje)',
            ],
            'description'         => [
                'fr' => 'Les sondages vous permettent de recueillir des avis / Les formulaires vous permettent de stocker des demandes',
                'en' => 'Surveys allow you to collect opinions / Forms allow you to store requests',
                'es' => 'Las encuestas le permiten recopilar opiniones / Los formularios le permiten almacenar solicitudes',
                'pt' => 'Pesquisas permitem que você colete opiniões / Formulários permitem que você armazene solicitações',
                'de' => 'Umfragen ermöglichen es Ihnen, Meinungen zu sammeln / Formulare ermöglichen es Ihnen, Anfragen zu speichern',
                'nl' => 'Enquêtes stellen u in staat meningen te verzamelen / Formulieren stellen u in staat verzoeken op te slaan',
            ],
            'settings'            => [
                'allowed_values' => [
                    'forms'   => [
                        'fr' => 'Formulaire',
                        'en' => 'Form',
                        'es' => 'Formulario',
                        'pt' => 'Formulário',
                        'de' => 'Formular',
                        'nl' => 'Formulier',
                    ],
                    'surveys' => [
                        'fr' => 'Sondage',
                        'en' => 'Survey',
                        'es' => 'Encuesta',
                        'pt' => 'Pesquisa',
                        'de' => 'Umfrage',
                        'nl' => 'Enquête',
                    ],
                ],
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight,
            ],
        ],
        // Image
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'forms_introduction',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => null,
            'title'               => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'es' => 'Introducción',
                'pt' => 'Introdução',
                'de' => 'Einführung',
                'nl' => 'Inleiding',
            ],
            'description'         => [
                'fr' => 'Ce paragraphe vous permet de présenter le sondage ou le formulaire',
                'en' => 'This paragraph allows you to introduce the survey or form',
                'es' => 'Este párrafo le permite presentar la encuesta o el formulario',
                'pt' => 'Este parágrafo permite que você apresente a pesquisa ou o formulário',
                'de' => 'Dieser Absatz ermöglicht es Ihnen, die Umfrage oder das Formular vorzustellen',
                'nl' => 'Dit paragraaf stelt u in staat de enquête of het formulier te introduceren',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight'   => $weight++,
            ],
        ],
        [
            'type'                => BridgeContentType::IMAGE_FIELD,
            'name'                => 'image',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'title'               => [
                'fr' => 'Bannière',
                'en' => 'Banner',
                'es' => 'Banner',
                'pt' => 'Banner',
                'de' => 'Banner',
                'nl' => 'Banner',
            ],
            'description'         => [
                'fr' => 'Cette image s’affiche sur toute la largeur',
                'en' => 'This image is displayed on the whole width',
                'es' => 'Esta imagen se muestra en toda la anchura',
                'pt' => 'Esta imagem é exibida em toda a largura',
                'de' => 'Dieses Bild wird auf der gesamten Breite angezeigt',
                'nl' => 'Deze afbeelding wordt over de hele breedte weergegeven',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'mimetypes'       => 'image/png,image/gif,image/jpeg',
                    'file_extensions' => 'png,gif,jpg,jpeg',
                    'max_filesize'    => 536870912,
                    'max_width'       => 300,
                    'max_height'      => 300,
                    'min_width'       => 250,
                    'min_height'      => 250,
                ],
                'weight' => $weight++,
            ],
        ],
        // Image d'aperçu
        [
            'name' => 'preview_image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Image d\'aperçu',
                'en' => 'Preview image',
                'es' => 'Imagen de vista previa',
                'pt' => 'Imagem de pré-visualização',
                'de' => 'Vorschaubild',
                'nl' => 'Voorbeeldafbeelding',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        // Champs de formulaire
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'inputs',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Préparez les champs',
                'en' => 'Prepare fields',
                'es' => 'Preparar campos',
                'pt' => 'Preparar campos',
                'de' => 'Felder vorbereiten',
                'nl' => 'Velden voorbereiden',
            ],
            'description'         => [
                'fr' => 'Vous pouvez créer autant de champs que souhaité',
                'en' => 'You can create as many fields as you want',
                'es' => 'Puede crear tantos campos como desee',
                'pt' => 'Você pode criar quantos campos desejar',
                'de' => 'Sie können so viele Felder erstellen, wie Sie möchten',
                'nl' => 'U kunt zoveel velden maken als u wilt',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
        ],
        // Limiter à une seule soumission
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'only_one_reply',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Les utilisateurs ne peuvent répondre qu’une seule fois',
                'en' => 'Users can only answer once',
                'es' => 'Los usuarios solo pueden responder una vez',
                'pt' => 'Os usuários só podem responder uma vez',
                'de' => 'Benutzer können nur einmal antworten',
                'nl' => 'Gebruikers kunnen slechts één keer antwoorden',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
                'es' => '',
                'pt' => '',
                'de' => '',
                'nl' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'general_settings',
            ],
        ],
        // Anonymiser les réponses d'un formulaire
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'anonym',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Les réponses sont anonymes',
                'en' => 'Answers are anonymous',
                'es' => 'Las respuestas son anónimas',
                'pt' => 'As respostas são anônimas',
                'de' => 'Antworten sind anonym',
                'nl' => 'Antwoorden zijn anoniem',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
                'es' => '',
                'pt' => '',
                'de' => '',
                'nl' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'general_settings',
            ],
        ],
        // Possède un statut de validation
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'has_status',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Les demandes des utilisateurs doivent être validées par les administrateurs',
                'en' => 'User requests must be validated by administrators',
                'es' => 'Las solicitudes de los usuarios deben ser validadas por los administradores',
                'pt' => 'As solicitações dos usuários devem ser validadas pelos administradores',
                'de' => 'Benutzeranfragen müssen von Administratoren validiert werden',
                'nl' => 'Gebruikersverzoeken moeten worden gevalideerd door beheerders',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
                'es' => '',
                'pt' => '',
                'de' => '',
                'nl' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'general_settings',
            ],
        ],
        // Afficher des tendances pour les utilisateurs
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'show_trends_user',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Après avoir répondu, les utilisateurs peuvent voir la moyenne des autres répondants',
                'en' => 'After responding, users can see the average of other respondents',
                'es' => 'Después de responder, los usuarios pueden ver el promedio de otros encuestados',
                'pt' => 'Depois de responder, os usuários podem ver a média de outros respondentes',
                'de' => 'Nach der Antwort können Benutzer den Durchschnitt anderer Befragter sehen',
                'nl' => 'Na het antwoorden kunnen gebruikers het gemiddelde van andere respondenten zien',
            ],
            'description'         => [
                'fr' => 'Utile principalement pour les sondages',
                'en' => 'Useful mainly for surveys',
                'es' => 'Útil principalmente para encuestas',
                'pt' => 'Principalmente útil para pesquisas',
                'de' => 'Hauptsächlich nützlich für Umfragen',
                'nl' => 'Voornamelijk nuttig voor enquêtes',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'general_settings',
            ],
        ],
        // Voir mes soumissions
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'show_my_replies',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => true,
            'title'               => [
                'fr' => 'Les utilisateurs peuvent consulter l’historique de leurs demandes',
                'en' => 'Users can view the history of their requests',
                'es' => 'Los usuarios pueden ver el historial de sus solicitudes',
                'pt' => 'Os usuários podem ver o histórico de suas solicitações',
                'de' => 'Benutzer können den Verlauf ihrer Anfragen anzeigen',
                'nl' => 'Gebruikers kunnen de geschiedenis van hun verzoeken bekijken',
            ],
            'description'         => [
                'fr' => 'Utile principalement pour les formulaires',
                'en' => 'Useful mainly for forms',
                'es' => 'Útil principalmente para formularios',
                'pt' => 'Principalmente útil para formulários',
                'de' => 'Hauptsächlich nützlich für Formulare',
                'nl' => 'Voornamelijk nuttig voor formulieren',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'user_settings',
            ],
        ],
        // Description Utilisateur
        [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'aside_desc_user',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Texte sur le bouton permettant d’accéder à son historique',
                'en' => 'Button text to access your history',
                'es' => 'Texto en el botón para acceder a su historial',
                'pt' => 'Texto no botão para acessar seu histórico',
                'de' => 'Schaltflächentext zum Zugriff auf Ihren Verlauf',
                'nl' => 'Knop tekst om uw geschiedenis te openen',
            ],
            'description'         => [
                'fr' => 'Exemple : vous pouvez retrouver l’historique de vos demandes et consulter leur avancée',
                'en' => 'Example : you can find your requests history and consult their progress',
                'es' => 'Ejemplo: puede encontrar el historial de sus solicitudes y consultar su progreso',
                'pt' => 'Exemplo: você pode encontrar o histórico de suas solicitações e consultar seu progresso',
                'de' => 'Beispiel: Sie können Ihr Anforderungshistorie finden und ihren Fortschritt überprüfen',
                'nl' => 'Voorbeeld: u kunt uw verzoekgeschiedenis vinden en hun voortgang controleren',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'user_settings',
            ],
        ],
        // Description administrateur
        [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'aside_desc_admin',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Texte sur le bouton permettant d’accéder à toutes les demandes',
                'en' => 'Button text to access all requests',
                'es' => 'Texto en el botón para acceder a todas las solicitudes',
                'pt' => 'Texto no botão para acessar todas as solicitações',
                'de' => 'Schaltflächentext zum Zugriff auf alle Anfragen',
                'nl' => 'Knop tekst om alle verzoeken te openen',
            ],
            'description'         => [
                'fr' => 'Exemple : Retrouvez ici les demandes des collaborateurs pour les gérer simplement',
                'en' => 'Example: Find here the collaborators requests to manage them easily',
                'es' => 'Ejemplo: Encuentre aquí las solicitudes de los colaboradores para gestionarlas fácilmente',
                'pt' => 'Exemplo: Encontre aqui as solicitações dos colaboradores para gerenciá-las facilmente',
                'de' => 'Beispiel: Finden Sie hier die Anfragen der Mitarbeiter, um sie einfach zu verwalten',
                'nl' => 'Voorbeeld: Vind hier de verzoeken van de medewerkers om ze eenvoudig te beheren',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'admin_settings',
            ],
        ],
    ],
];
