<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => (count(list_languages()) > 1),
        'searchable'        => false,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => false,
        'name'              => 'forms',
        'title'             => [
            'fr' => 'Formulaires & sondages',
            'en' => 'Forms & surveys',
        ],
    ],
    'fields'  => [
        // Type de formulaire (Formulaire / Sondage)
        [
            'type'                => BridgeContentType::LIST_STRING_FIELD,
            'name'                => 'form_type',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'default'             => 'forms',
            'weight'              => $weight,
            'title'               => [
                'fr' => 'Quel type de contenu souhaitez-vous créer ? (case à cocher)',
                'en' => 'What type of content would you like to create? (check box)',
            ],
            'description'         => [
                'fr' => 'Les sondages vous permettent de recueillir des avis / Les formulaires vous permettent de stocker des demandes',
                'en' => 'Surveys allow you to collect opinions / Forms allow you to store requests',
            ],
            'settings'            => [
                'allowed_values' => [
                    'forms'   => [
                        'fr' => 'Formulaire',
                        'en' => 'Form',
                    ],
                    'surveys' => [
                        'fr' => 'Sondage',
                        'en' => 'Survey',
                    ],
                ],
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight,
            ],
        ],
        // Image
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'forms_introduction',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => null,
            'title'               => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
            ],
            'description'         => [
                'fr' => 'Ce paragraphe vous permet de présenter le sondage ou le formulaire',
                'en' => 'This paragraph allows you to introduce the survey or form',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight'   => $weight++,
            ],
        ],
        [
            'type'                => BridgeContentType::IMAGE_FIELD,
            'name'                => 'image',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'title'               => [
                'fr' => 'Bannière',
                'en' => 'Banner',
            ],
            'description'         => [
                'fr' => 'Cette image s’affiche sur toute la largeur',
                'en' => 'This image is displayed on the whole width',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'mimetypes'       => 'image/png,image/gif,image/jpeg',
                    'file_extensions' => 'png,gif,jpg,jpeg',
                    'max_filesize'    => 536870912,
                    'max_width'       => 300,
                    'max_height'      => 300,
                    'min_width'       => 250,
                    'min_height'      => 250,
                ],
                'weight' => $weight++,
            ],
        ],
        // Champs de formulaire
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'inputs',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Préparez les champs',
                'en' => 'Prepare fields',
            ],
            'description'         => [
                'fr' => 'Vous pouvez créer autant de champs que souhaité',
                'en' => 'You can create as many fields as you want',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
        ],
        // Limiter à une seule soumission
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'only_one_reply',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Les utilisateurs ne peuvent répondre qu’une seule fois',
                'en' => 'Users can only answer once',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'general_settings',
            ],
        ],
        // Anonymiser les réponses d'un formulaire
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'anonym',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Les réponses sont anonymes',
                'en' => 'Answers are anonymous',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'general_settings',
            ],
        ],
        // Possède un statut de validation
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'has_status',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Les demandes des utilisateurs doivent être validées par les administrateurs',
                'en' => 'User requests must be validated by administrators',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'general_settings',
            ],
        ],
        // Afficher des tendances pour les utilisateurs
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'show_trends_user',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Après avoir répondu, les utilisateurs peuvent voir la moyenne des autres répondants',
                'en' => 'After responding, users can see the average of other respondents',
            ],
            'description'         => [
                'fr' => 'Utile principalement pour les sondages',
                'en' => 'Useful mainly for surveys',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'general_settings',
            ],
        ],
        // Voir mes soumissions
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'show_my_replies',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => true,
            'title'               => [
                'fr' => 'Les utilisateurs peuvent consulter l’historique de leurs demandes',
                'en' => 'Users can view the history of their requests',
            ],
            'description'         => [
                'fr' => 'Utile principalement pour les formulaires',
                'en' => 'Useful mainly for forms',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'user_settings',
            ],
        ],
        // Description Utilisateur
        [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'aside_desc_user',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Texte sur le bouton permettant d’accéder à son historique',
                'en' => 'Button text to access your history',
            ],
            'description'         => [
                'fr' => 'Exemple : vous pouvez retrouver l’historique de vos demandes et consulter leur avancée',
                'en' => 'Example : you can find your requests history and consult their progress',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'user_settings',
            ],
        ],
        // Description administrateur
        [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'aside_desc_admin',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'default'             => false,
            'title'               => [
                'fr' => 'Texte sur le bouton permettant d’accéder à toutes les demandes',
                'en' => 'Button text to access all requests',
            ],
            'description'         => [
                'fr' => 'Exemple : Retrouvez ici les demandes des collaborateurs pour les gérer simplement',
                'en' => 'Example: Find here the collaborators requests to manage them easily',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'admin_settings',
            ],
        ],
    ],
];
