<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => (count(list_languages()) > 1),
        'searchable'        => false,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => false,
        'name'              => 'forms',
        'title'             => [
            'fr' => 'Formulaires & sondages',
            'en' => 'Forms & surveys',
        ],
    ],
    'fields'  => [
        // Image
        [
            'type'                => BridgeContentType::IMAGE_FIELD,
            'name'                => 'image',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Image',
                'en' => 'Image',
            ],
            'description'         => [
                'fr' => 'L\image illustrant le formulaire ou le sondage',
                'en' => 'Form\'s image',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'mimetypes'       => 'image/png,image/gif,image/jpeg',
                    'file_extensions' => 'png,gif,jpg,jpeg',
                    'max_filesize'    => 536870912,
                    'max_width'       => 300,
                    'max_height'      => 300,
                    'min_width'       => 250,
                    'min_height'      => 250,
                ],
            ],
        ],
        // Type de formulaire (Formulaire / Sondage)
        [
            'type'                => BridgeContentType::LIST_STRING_FIELD,
            'name'                => 'form_type',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'default'             => 'forms',
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Type',
                'en' => 'Type',
            ],
            'description'         => [
                'fr' => 'Type de formulaire (Formulaire / Sondage)',
                'en' => 'Form Type (Form / Survey)',
            ],
            'settings'            => [
                'allowed_values' => [
                    'forms'   => [
                        'fr' => 'Formulaire',
                        'en' => 'Form',
                    ],
                    'surveys' => [
                        'fr' => 'Sondage',
                        'en' => 'Survey',
                    ],
                ],
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],

        // Afficher des tendances pour les utilisateurs
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'show_trends_user',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => false,
            'title'               => [
                'fr' => 'Afficher des tendances pour les utilisateurs',
                'en' => 'View trends for users',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
        ],

        // Afficher des tendances pour l'admin
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'show_trends_admin',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => false,
            'title'               => [
                'fr' => 'Afficher des tendances pour l\'admin',
                'en' => 'View trends for admins',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
        ],

        // Voir les tendances avant la soumission
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'show_trends_firstly',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => false,
            'title'               => [
                'fr' => 'Voir les tendances avant la soumission',
                'en' => 'See trends before submission',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
        ],

        // Afficher les contributeurs pour les utilisateurs
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'show_contributors_user',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => false,
            'title'               => [
                'fr' => 'Afficher les contributeurs pour les utilisateurs',
                'en' => 'View contributors for users',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
        ],

        // Afficher les contributeurs pour l'admin
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'show_contributors_admin',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => false,
            'title'               => [
                'fr' => 'Afficher les contributeurs pour l\'admin',
                'en' => 'View contributors for admin',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
        ],

        // Limiter à une seule soumission
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'only_one_reply',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => false,
            'title'               => [
                'fr' => 'Limiter à une seule soumission',
                'en' => 'Limit to a single submission',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
        ],

        // Anonymiser les réponses d'un formulaire
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'anonym',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => false,
            'title'               => [
                'fr' => 'Anonymiser les réponses d\'un formulaire',
                'en' => 'Anonymize the answers of a form',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
        ],

        // Voir mes soumissions
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'show_my_replies',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => true,
            'title'               => [
                'fr' => 'Voir mes soumissions',
                'en' => 'See my submissions',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
        ],

        // Possède un statut de validation
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'has_status',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => false,
            'title'               => [
                'fr' => 'Possède un statut de validation',
                'en' => 'Has a validation status',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
        ],

        // Champs de formulaire
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'inputs',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => false,
            'title'               => [
                'fr' => 'Champs de formulaire',
                'en' => 'Form fields',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
            ],
        ],

        // Description administrateur
        [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'aside_desc_admin',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => false,
            'title'               => [
                'fr' => 'Description administrateur',
                'en' => 'Admin description',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
            ],
        ],

        // Description Utilisateur
        [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'aside_desc_user',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => false,
            'title'               => [
                'fr' => 'Description Utilisateur',
                'en' => 'User description',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
            ],
        ],

        // Administrateurs
        [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'admin_roles',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'hidden'              => true,
            'default'             => '[]',
            'title'               => [
                'fr' => 'Administrateurs',
                'en' => 'Administrators',
            ],
            'description'         => [
                'fr' => 'La liste des administrateurs',
                'en' => 'Admin list',
            ],
            'widget'              => [
                'hidden' => true,
            ],
        ],

        // Catégorie d'actualité
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'news_categories',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => true,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Catégories d\'actualité',
                'en' => 'News categories',
            ],
            'description'         => [
                'fr' => '',
                'en' => '',
            ],
            'settings'            => [
                'cardinality' => -1,
                'target_type' => 'news_categories',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
    ],
];
