<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => 'Inside\Form\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->post(
            'forms/answers',
            ['uses' => 'FormController@storeAnswers']
        );
        $router->get(
            'forms/{related}/answers',
            ['uses' => 'FormController@getAnswers']
        );

        $router->get(
            'forms/{related}/answers-count/{user}',
            ['uses' => 'FormController@getAnswersCount']
        );

        $router->get(
            'forms/{related}/answers-count',
            ['uses' => 'FormController@getAnswersCount']
        );

        $router->get(
            'forms/{related}/submissions/{submission}',
            ['uses' => 'FormController@getSubmission']
        );

        $router->put(
            'forms/{related}/submissions/{submission}',
            ['uses' => 'FormController@updateSubmission']
        );
        $router->put(
            'forms/submissions/{submission}',
            ['uses' => 'FormController@editSubmissionStatus']
        );
        $router->get(
            'forms/{related}/admin',
            ['uses' => 'FormController@checkUserAdmin']
        );
        $router->delete(
            'forms/{related}/submissions/{submission}',
            ['uses' => 'FormController@deleteSubmission']
        );
        $router->get(
            'forms/{related}/contributors',
            ['uses' => 'FormController@getContributors']
        );
        $router->get(
            'forms/{related}/export',
            ['uses' => 'FormController@exportSubmissions']
        );
    }
);
