<?php

namespace Inside\Form\Services;

use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Authentication\Models\User as AuthenticatedUser;
use Inside\Content\Models\Contents\Forms;
use Inside\Content\Models\Contents\Users;
use Inside\Form\Models\FormSubmission;

class FormUsersService
{
    private ?User $userAuthenticatedForJob = null;

    /**
     * @param string $related
     * @return array
     */
    public function getContributors(string $related)
    {
        $submissionUsers =
            FormSubmission::select('user_uuid')->where('answerable_uuid', $related)->distinct('user_uuid')->get()
                ->pluck('user_uuid');
        $users = [];
        foreach ($submissionUsers as $uuid) {
            $user = Users::find($uuid);
            if ($user) {
                $image = $user->image;

                if ($image) {
                    $image = protected_file_url($user, 'image');
                }

                array_push(
                    $users,
                    [
                        'firstname' => $user->firstname,
                        'lastname'  => $user->lastname,
                        'image'     => $image,
                        'uuid'      => $uuid,
                    ]
                );
            }
        }

        return $users;
    }

    /**
     * @param string $related
     * @return array|null
     */
    public function checkUserAdmin(string $related): ?array
    {
        return ['isAdmin' => $this->isAdmin($related)];
    }

    /**
     * @param string $formUuid
     * @param AuthenticatedUser|null $me
     * @return bool
     */
    public function isAdmin(string $formUuid, AuthenticatedUser $me = null): bool
    {
        if ($this->userAuthenticatedForJob !== null) {
            $me = $this->userAuthenticatedForJob;
        }

        if ($me === null) {
            /** @var AuthenticatedUser $me */
            $me = User::find(Auth::user()->uuid);
        }

        if ($me->isSuperAdmin()) {
            return true;
        }

        $form = Forms::findOrFail($formUuid);
        $roles = json_decode($form->admin_roles);

        return $roles && $me->roles->whereIN('id', $roles)->isNotEmpty();
    }

    public function setUserAuthenticatedForJob(User $user): void
    {
        $this->userAuthenticatedForJob = $user;
    }

    public function getUserAuthenticatedForJob(): ?User
    {
        return $this->userAuthenticatedForJob;
    }
}
