<?php

namespace Inside\Form\Providers;

use Illuminate\Support\Facades\Log;
use Inside\Content\Events\ContentDeletedEvent;
use Inside\Form\Events\FormSubmissionStatusEditedEvent;
use Inside\Form\Events\FormSubmitedEvent;
use Inside\Form\Http\Middlewares\ContentFormMiddleware;
use Inside\Form\Listeners\ContentDeletedListener;
use Inside\Form\Listeners\FormStatusListener;
use Inside\Form\Listeners\FormSubmittedUsersListener;
use Inside\Support\EventServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class FormServiceProvider extends EventServiceProvider
{
    protected array $listen = [
        FormSubmitedEvent::class => [
            FormSubmittedUsersListener::class,
        ],
        FormSubmissionStatusEditedEvent::class => [
            FormStatusListener::class,
        ],
        ContentDeletedEvent::class => [
            ContentDeletedListener::class,
        ],
    ];

    public function register(): void
    {
        $this->app->middleware(
            [
                ContentFormMiddleware::class,
            ]
        );
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/resource.php', 'resource');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/form.php', 'form');
        } catch (NotFoundExceptionInterface | ContainerExceptionInterface) {
            Log::debug('Missing config files');
        }
    }
}
