<?php

namespace Inside\Form\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

/**
 * @method static Builder|static whereHas(string $relation, \Closure|null  $callback = null, string $operator = '>=', int $count = 1)
 * @method static Collection get(array $columns = ['*'])
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 *
 * @property string|array $answer
 * @property string $field_type
 * @property FormSubmission $submission
 * @property string $field_id
 */
class FormAnswer extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_forms_answers';

    /**
     * Casts the following attributes
     *
     * @var array
     */
    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
        'answer' => 'array',
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'field_id',
        'field_type',
        'answer',
    ];

    /**
     * The submission that owns the answer.
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function submission()
    {
        return $this->belongsTo('Inside\Form\Models\FormSubmission', 'submission_id', 'id');
    }
}
