<?php

namespace Inside\Form\Seeders;

use Illuminate\Database\Seeder;
use Inside\Notify\Models\NotificationType;

class FormNotificationsSeeder extends Seeder
{
    public function run(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => false,
                'event'     => 'Inside\Form\Events\FormSubmitedEvent',
                'model'     => 'Inside\Form\Models\FormSubmission',
                'action'    => 'submit',
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
            ],
            [
                'data' => [
                    'view'        => 'form-submit',
                    'title'       => 'notifications.submit.form.title',
                    'description' => 'notifications.submit.form.description',
                    'mail'        => [],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => false,
                'event'     => 'Inside\Form\Events\FormAnswersEditedEvent',
                'model'     => 'Inside\Form\Models\FormSubmission',
                'action'    => 'edit',
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
            ],
            [
                'data' => [
                    'view'        => 'form-answers-edited',
                    'title'       => 'notifications.answers.edit.form.title',
                    'description' => 'notifications.answers.edit.form.description',
                    'mail'        => [],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => false,
                'event'     => 'Inside\Form\Events\FormStatusEditedEvent',
                'model'     => 'Inside\Form\Models\FormSubmission',
                'action'    => 'edit',
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title'        => 'notifications.status.edit.form.title',
                    'description'  => 'notifications.status.edit.form.description',
                    'mail'         => [
                        'subject'       => 'notifications.status.edit.form.mail.subject',
                        'text'          => 'notifications.status.edit.form.mail.content',
                        'buttonText'    => 'notifications.status.edit.form.mail.buttonText',
                    ],
                ],
            ]
        );
        /*
                NotificationType::firstOrCreate(
                    [
                        'via'       => 'email',
                        'default'   => false,
                        'event'     => 'Inside\Form\Events\FormStatusEditedEvent',
                        'model'     => 'Inside\Form\Models\FormSubmission',
                        'action'    => 'edit',
                        'multiple'  => false,
                        'language'  => false,
                        'profile'   => false
                    ],
                    [
                        'data' => [
                            'title'        => 'notifications.leaverequest.title',
                            'description'  => 'notifications.leaverequest.description',
                            'mail'         => [
                                'subject'       => 'notifications.leaverequest.mail.subject',
                                'text'          => 'notifications.leaverequest.mail.text',
                                'buttonText'    => 'notifications.leaverequest.mail.buttonText',
                            ],
                            'machine_name' => 'leave_request',
                        ],
                    ]
                );*/

        $this->command->info('Notification type created');
    }
}
