<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddPreviewDescriptionImageToForms extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'forms',
            fieldName: 'preview_image',
            options: [
                'name' => 'preview_image',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => -1,
                'title' => [
                    'fr' => 'Image d\'aperçu',
                    'en' => 'Preview image',
                    'es' => 'Imagen de vista previa',
                    'pt' => 'Imagem de pré-visualização',
                    'de' => 'Vorschaubild',
                    'nl' => 'Voorbeeldafbeelding',
                ],
                'description' => [
                    'fr' => 'Cette image sera utilisée pour la remontée du formulaire ou du sondage dans les différents contenus de votre plateforme',
                    'en' => 'This image will be used for the feedback of the form or survey in the different contents of your platform',
                    'es' => 'Esta imagen se utilizará para la retroalimentación del formulario o encuesta en los diferentes contenidos de su plataforma',
                    'pt' => 'Esta imagem será usada para o feedback do formulário ou pesquisa nos diferentes conteúdos de sua plataforma',
                    'de' => 'Dieses Bild wird für das Feedback des Formulars oder der Umfrage in den verschiedenen Inhalten Ihrer Plattform verwendet',
                    'nl' => 'Deze afbeelding wordt gebruikt voor de feedback van het formulier of de enquête in de verschillende inhoud van uw platform',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => -1,
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
            ],
        );
    }
}
