<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Notify\Models\NotificationType;

class AddSubmissionStatusUpdatedAdminNotificationTypes extends Migration
{
    public function up(): void
    {
        $notificationTypes = [
            // Mail notificationTypes
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdatedAdmin',
                'type' => 'system',
                'condition' => 'status:1',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data' => [
                    'mail' => [
                        'subject' => 'notifications.form.submission.accepted.email.subject',
                        'text' => 'notifications.form.submission.accepted.email.text',
                        'buttonText' => 'notifications.form.submission.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ],
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdatedAdmin',
                'type' => 'system',
                'condition' => 'status:0',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data' => [
                    'mail' => [
                        'subject' => 'notifications.form.submission.refused.email.subject',
                        'text' => 'notifications.form.submission.refused.email.text',
                        'buttonText' => 'notifications.form.submission.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ],
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdatedAdmin',
                'type' => 'system',
                'condition' => 'status:2',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data' => [
                    'mail' => [
                        'subject' => 'notifications.form.submission.pending.email.subject',
                        'text' => 'notifications.form.submission.pending.email.text',
                        'buttonText' => 'notifications.form.submission.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ],

            // Web notificationTypes
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdatedAdmin',
                'type' => 'global',
                'condition' => 'status:1',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data' => [
                    'text' => 'notifications.form.admin.submission.accepted.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ],
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdatedAdmin',
                'type' => 'global',
                'condition' => 'status:0',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data' => [
                    'text' => 'notifications.form.admin.submission.refused.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ],
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Form\Events\FormSubmissionStatusEditedEvent',
                'model' => 'Inside\Form\Models\FormSubmission',
                'action' => 'statusUpdatedAdmin',
                'type' => 'global',
                'condition' => 'status:2',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data' => [
                    'text' => 'notifications.form.admin.submission.pending.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ],
        ];

        foreach ($notificationTypes as $notificationType) {
            NotificationType::firstOrCreate($notificationType);
        }
    }
}
