<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSubmissionComment extends Migration
{
    public function up(): void
    {
        if (Schema::hasColumns('inside_forms_submissions', ['comment'])) {
            return;
        }

        Schema::table('inside_forms_submissions', function (Blueprint $table) {
            $table->longText('comment')->nullable();
        });
    }

    public function down(): void
    {
        if (! Schema::hasColumns('inside_forms_submissions', ['comment'])) {
            return;
        }

        Schema::table('inside_forms_submissions', function (Blueprint $table) {
            $table->dropColumn(['comment']);
        });
    }
}
