<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ImproveForms extends Migration
{
    use Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('forms');

        $this->finishUp();

        $console = $this->getConsole();

        $console->writeln('Removing useless fields ...');

        $bridge = new BridgeContentType();

        $fields = [
            'show_contributors_user',
            'show_trends_firstly',
            'show_contributors_admin',
            'show_trends_admin',
        ];
        foreach ($fields as $field) {
            $console->write('removing '.$field.' field ...');
            $bridge->contentTypeDeleteField('node', 'forms', $field);
            $console->writeln(' <fg=green>✔</fg=green>');
        }
        $console->writeln('improving forms ...');

        $console->writeln('creating new fieldsets ...');

        $fieldSets = [
            'general_settings' => [
                'fr' => 'Paramètres généraux',
                'en' => 'General settings',
            ],
            'user_settings' => [
                'fr' => 'Paramètres pour les utilisateurs',
                'en' => 'Users settings',
            ],
            'admin_settings' => [
                'fr' => 'Paramètres pour les administrateurs',
                'en' => 'Administrators settings',
            ],
        ];

        $weight = 6;
        foreach ($fieldSets as $key => $translations) {
            $console->write('creating fieldset '.$key);
            $bridge->createOrUpdateFieldGroup('forms', $key, $translations, $weight++);
            $console->writeln(' <fg=green>✔</fg=green>');
        }
    }
}
