<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class AddIntroductionToForm extends Migration
{
    public function up(): void
    {
        if (! InsideSchema::hasModel('forms')) {
            return;
        }

        $bridge = new BridgeContentType();

        try {
            $bridge->contentTypeCreateOrUpdateField(
                'forms',
                'introduction',
                [
                    'type'                => BridgeContentType::TEXTAREA_FIELD,
                    'name'                => 'introduction',
                    'searchable'          => false,
                    'translatable'        => (count(list_languages()) > 1),
                    'search_result_field' => false,
                    'required'            => false,
                    'weight'              => 1,
                    'default'             => null,
                    'title'               => [
                        'fr' => 'Introduction',
                        'en' => 'Introduction',
                    ],
                    'description'         => [
                        'fr' => '',
                        'en' => '',
                    ],
                    'settings'            => [],
                    'widget'              => [
                        'type'     => BridgeContentType::LONGTEXT_WIDGET,
                        'settings' => [],
                        'weight'   => -1,
                    ],
                ],
                -4
            );
        } catch (Throwable $e) {
        }
    }
}
