<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class ehanceFormsMailNotifications extends Migration
{
    protected array $notificationtype = [
        'via'      => 'email',
        'type'     => 'global',
        'default'  => true,
        'event'    => 'Inside\Form\Events\FormSubmitedEvent',
        'model'    => 'Inside\Form\Models\FormSubmission',
        'action'   => 'submit',
        'multiple' => false,
        'language' => false,
        'profile'  => false,
        'data'     => [
            'title'       => 'notifications.submit.form.title',
            'description' => 'notifications.submit.form.description',
            'mail'        => [
                'subject'    => 'notifications.submit.form.mail.<answerable.form_type>.subject',
                'text'       => 'notifications.submit.form.mail.<answerable.form_type>.content',
                'buttonText' => 'notifications.submit.form.mail.<answerable.form_type>.buttonText',
            ],
        ],
    ];

    public function up(): void
    {
        /** @var ?NotificationType $notificationType */
        $notificationType = NotificationType::where(array_except($this->notificationtype, 'data'))->where('data', 'NOT LIKE', '%"view":"form-submit"%')->first();
        if (! $notificationType) {
            NotificationType::create($this->notificationtype);
        } else {
            $notificationType->data = $this->notificationtype['data'];
            $notificationType->save();
        }
    }
}
