<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class DropFormsAnswersLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::dropIfExists('inside_forms_answers_logs');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::create('inside_forms_answers_logs', function (Blueprint $table) {
            $table->increments('id');
            $table->uuid('user_uuid');
            $table->integer('answer_id')->unsigned();
            $table->longText('new_answer');
            $table->timestamps();
            $table->index('user_uuid');
            $table->foreign('user_uuid')
                ->references('uuid')->on('inside_content_users')
                ->onDelete('cascade');
            $table->foreign('answer_id')
                ->references('id')->on('inside_forms_answers')
                ->onDelete('cascade');
        });
    }
}
