<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFormsAnswersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('inside_forms_answers', function (Blueprint $table) {
            $table->increments('id');
            $table->uuid('user_uuid');
            $table->uuid('answerable_uuid');
            $table->string('answerable_type');
            $table->uuid('field_id');
            $table->char('field_type', 36)->nullable();
            $table->longText('answer')->nullable();
            $table->timestamps();
            $table->index('user_uuid');
            $table->index(['answerable_uuid', 'answerable_type']);
            $table->foreign('user_uuid')
                ->references('uuid')->on('inside_content_users')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inside_forms_answers');
    }
}
