<?php

use Inside\Form\Facades\FormUsers;
use Inside\Form\Models\FormSubmission;

return [
    'accredit' => [
        'form' => function ($form, $me, $path): bool {
            if (class_to_type($form) !== 'forms') {
                return false;
            }

            // We need to check $me is admin of $model
            if (FormUsers::isAdmin($form->uuid, $me)) {
                return true; // admin can see that !
            }

            // Get filename
            [$submissionId] = explode('-', basename($path), 1);

            $submission = FormSubmission::find($submissionId);
            if (! $submission) {
                return false;
            }

            return $submission->user_uuid === $me->uuid;
        },
    ],
];
