<?php

use Drupal\Core\DrupalKernel;
use Symfony\Component\HttpFoundation\Request;

// Save memory usage & time for profiling
$GLOBALS['INSIDE_START_TIME'] = microtime(true);
$GLOBALS['INSIDE_START_MEMORY'] = memory_get_usage();

$paths = [
  'admin',
  'node',
  'comment',
  'user',
  'batch',
  'core',
  'modules',
  'sites',
  'entity_reference_autocomplete',
  'machine_name',
  'editor',
];

$requestURI = filter_input(INPUT_SERVER, 'REQUEST_URI', FILTER_SANITIZE_URL);

$GLOBALS['bootDrupal'] = false;
$GLOBALS['bootInside'] = true;

// Decompose uri
$decomposed = explode('/', trim(strtok($requestURI, '?'), '/'));

if (count($decomposed) >= 2) {
    if (preg_match('/^[a-z]{2}$/', $decomposed[0])) {
        // Prefixed lang
        if (in_array($decomposed[1], $paths)) {
            $GLOBALS['bootDrupal'] = true;
            $GLOBALS['bootInside'] = false;
        }
    } else {
        if (in_array($decomposed[0], $paths)) {
            $GLOBALS['bootDrupal'] = true;
            $GLOBALS['bootInside'] = false;
        }
    }
} elseif (! empty($decomposed)) {
    if (in_array($decomposed[0], $paths)) {
        $GLOBALS['bootDrupal'] = true;
        $GLOBALS['bootInside'] = false;
    }
}

if ($GLOBALS['bootDrupal']) {
  $autoloader = require_once 'autoload.php';

  $kernel = new DrupalKernel('prod', $autoloader);

  $request = Request::createFromGlobals();
  $response = $kernel->handle($request);
  $response->send();

  $kernel->terminate($request, $response);
} else {
  $app = require __DIR__.'/vendor/maecia/inside/bootstrap/app.php';
  $app->run();
}
