<?php

// @codingStandardsIgnoreFile

require_once __DIR__ . '/../../vendor/autoload.php';

(new \Laravel\Lumen\Bootstrap\LoadEnvironmentVariables(
    dirname(realpath(__DIR__.'/../'))
))->bootstrap();

$settings['config_sync_directory'] = __DIR__ . '/../../storage/app/sync';

$databases = [];

$config_directories = [];

$settings['hash_salt'] = 'ZbDCa32vkTU4UxUm7spiIQJJiOuOjq6AqhyaQpGC68KBHg4_n2cRt3FBkZ8nsAUtVxkiMA5aow';

$settings['update_free_access'] = false;

$settings['container_yamls'][] = $app_root . '/' . $site_path . '/services.yml';

$settings['file_scan_ignore_directories'] = [
    'node_modules',
    'bower_components',
];

$settings['entity_update_batch_size'] = 50;

$settings['class_loader_auto_detect'] = false;

$databases['default']['default'] = [
    'database'  => env('DB_DATABASE', env('APP_CODE', 'sid2')),
    'username'  => env('DB_USERNAME', env('APP_CODE', 'sid2')),
    'password'  => env('DB_PASSWORD'),
    'prefix'    => '',
    'host'      => env('DB_HOST'),
    'port'      => env('DB_PORT', env('DB_CONNECTION') === 'pgsql' ? 5432 : 3306),
    'namespace' => env('DB_CONNECTION') === 'mysql' ? 'Drupal\\Core\\Database\\Driver\\mysql' : 'Drupal\\Core\\Database\\Driver\\pgsql',
    'driver'    => env('DB_CONNECTION', 'mysql'),
    'collation' => env('DB_CONNECTION') === 'pgsql' ? 'utf8' : env('DB_COLLATION', 'utf8mb4_general_ci'),
];

$settings['install_profile'] = 'minimal';

$settings['file_public_path'] = 'storage/app';
$settings['file_private_path'] = null;

$settings['cache']['default']                    = 'cache.backend.database';
$settings['cache']['bins']['render']             = 'cache.backend.null';
$settings['cache']['bins']['dynamic_page_cache'] = 'cache.backend.null';
$settings['cache']['bins']['page']               = 'cache.backend.null';
$settings['cache']['bins']['discovery']          = 'cache.backend.null';

$config['system.performance']['css']['preprocess'] = false;
$config['system.performance']['js']['preprocess']  = false;

$config['system.file']['path']['temporary'] = 'storage/tmp';

$config['automated_cron.settings']['interval'] = 0;

$settings['trusted_host_patterns'] = [
    '^$',
    '^localhost$',
    '^localhost\.*',
    '^' . env('APP_CODE') . '\.maecia$',
    '^' . env('APP_CODE') . '\.maecia\.*',
    '^' . env('APP_CODE') . '\.staging.maecia.com$',
    '^' . env('APP_CODE') . '\.staging.maecia.com\.*',
];

$app_url = parse_url(env('APP_URL'));

if ($app_url) {
    if (strstr($app_url['host'], 'www.') === false) {
        $settings['trusted_host_patterns'][] = '^www\.' . str_replace('.', '\.', $app_url['host']) . '$';
        $settings['trusted_host_patterns'][] = '^www\.' . str_replace('.', '\.', $app_url['host']) . '\.*';
    }

    if (strstr($app_url['host'], 'www.') !== false) {
        $settings['trusted_host_patterns'][] = '^' . str_replace('.', '\.', str_replace('www.', '', $app_url['host'])) . '$';
        $settings['trusted_host_patterns'][] = '^' . str_replace('.', '\.', str_replace('www.', '', $app_url['host'])) . '\.*';
    }

    $settings['trusted_host_patterns'][] = '^' . str_replace('.', '\.', $app_url['host']) . '$';
    $settings['trusted_host_patterns'][] = '^' . str_replace('.', '\.', $app_url['host']) . '\.*';
}

# Error level
$config['system.logging']['error_level'] =  ERROR_REPORTING_HIDE;
