<?php

namespace Inside\Host\Services;

use Inside\Services\InsideService as InsideServiceSystem;

/**
 * Inside Service
 *
 * @category Class
 * @package  Inside\Host\Services\InsideService
 * @author   Maecia <technique@maecia.com>
 * @link     http://www.maecia.com/
 */
class InsideService
{
    /**
     * The service
     */
    protected InsideServiceSystem $app;

    /**
     * Create a new Inside service instance
     */
    public function __construct()
    {
        $this->app = InsideServiceSystem::getInstance();
    }

    /**
     * Return the app
     */
    public function getApp(): InsideServiceSystem
    {
        return $this->app;
    }
}
