<?php

namespace Inside\Host\PathProcessor;

use Drupal\Core\PathProcessor\InboundPathProcessorInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Hack all Drupal 8 routes
 *
 * @category  Class
 * @package   Inside\Host\PathProcessor
 * @author    Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link      http://www.maecia.com/
 */
class PathProcessor implements InboundPathProcessorInterface
{
    /**
     * Temporary admin_path
     *
     * @var array
     */

    const ADMIN_PATH = [
        '/admin',
        '/node',
        '/comment',
        '/user',
        '/batch',
        '/core',
        '/modules',
        '/sites',
        '/entity_reference_autocomplete',
        '/machine_name',
        '/editor',
    ];

    const AUTHORIZED_PATH = [
        '/node',
    ];

    /**
     * {@inheritdoc}
     */
    public function processInbound($path, Request $request)
    {
        if (php_sapi_name() == 'cli') {
            return $path;
        }

        $hasAdminAccess = \Drupal::currentUser()->hasPermission('administer site configuration');

        if ($hasAdminAccess) {
            foreach (self::ADMIN_PATH as $adminPath) {
                if (str_starts_with($path, $adminPath)) {
                    return $path;
                }
            }
        }

        foreach (self::AUTHORIZED_PATH as $authorizedPath) {
            if (str_starts_with($path, $authorizedPath)) {
                return $path;
            }
        }

        if (!$hasAdminAccess && $GLOBALS['bootDrupal']) {
            $GLOBALS['bootDrupal'] = false;
            $GLOBALS['bootInside'] = true;
            $GLOBALS['fromDrupal'] = true;
            // Switch to inside from drupal
            $app = require cms_base_path('vendor/maecia/inside/bootstrap/app.php');
            $app->run();
        }
    }
}
