<?php

namespace Inside\Host\Normalizer;

use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\TypedData\ComplexDataInterface;
use Drupal\Core\TypedData\TypedDataInternalPropertiesHelper;
use Drupal\node\Entity\Node;
use Drupal\serialization\Normalizer\ComplexDataNormalizer;
use Log;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

/**
 * Field Item Normalizer
 *
 * @category Class
 * @package  Inside\Host\Normalizer\FieldItemNormalizer
 * @author   Maecia <technique@maecia.com>
 * @author   Nicolas Deniaud <contact@feldoe.net>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class FieldItemNormalizer extends ComplexDataNormalizer implements NormalizerInterface, DenormalizerInterface
{
    /**
     * {@inheritdoc}
     */
    protected $supportedInterfaceOrClass = FieldItemInterface::class;

    /**
     * {@inheritdoc}
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $attributes = [];

        if ($object instanceof ComplexDataInterface) {
            // If there are no properties to normalize, just normalize the value.
            $object = !empty($object->getProperties(true)) ? TypedDataInternalPropertiesHelper::getNonInternalProperties($object) : $object->getValue();
        }

        foreach ($object as $name => $property) {
            $attributes[$name] = $this->serializer->normalize($property, $format, $context);
        }

        if (isset($attributes['value'])) {
            return $attributes['value'];
        }

        return $attributes;
    }

    /**
     * {@inheritdoc}
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (!isset($context['target_instance'])) {
            throw new \InvalidArgumentException('$context[\'target_instance\'] must be set to denormalize with the FieldItemNormalizer');
        }

        if ($context['target_instance']->getParent() == null) {
            throw new \InvalidArgumentException('The field item passed in via $context[\'target_instance\'] must have a parent set.');
        }

        $item = $context['target_instance'];

        $item->setValue($data);

        return $item;
    }
}
