<?php

namespace Inside\Host\Helpers\Adapter\Form;

/**
 * Flatten formDisplay from Drupal 8
 *
 * @category  Class
 * @package   Inside\Host\Adapter\Form\NodeForm
 * @author    Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link      http://www.maecia.com/
 */
class NodeForm extends BaseForm
{

    /**
     * {@inheritDoc}
     */
    protected const REMOVABLE_FIELD = [
        'path',
        'promote',
        'sticky',
        'translation',
        'revision_log',
        'nid',
        'uuid',
        'vid',
        'type',
        'revision_timestamp',
        'revision_uid',
        'default_langcode',
        'revision_default',
        'revision_translation_affected',
        'content_translation_source',
        'content_translation_outdated',
    ];

    /**
     * {@inheritDoc}
     */
    protected const FIELD_NAME = [
        'created' => 'created_at',
        'changed' => 'updated_at',
        'uid'     => 'author',
    ];

    /**
     * {@inheritDoc}
     */
    protected function handleAttributeFields(string $name, $field = null, bool $isHidden = false): void
    {
        \Drupal::service('inside');
        $model     = $this->getModel();
        $saveField = false;
        $title     = '';
        $type      = 'text';
        $weight    = 0;

        if (is_array($field)) {
            $weight = $field['weight'];
        }

        $options = [
            'cardinality'         => 1,
            'translatable'        => true,
            'required'            => true,
            'weight'              => $weight,
            'default'             => null,
            'widget'              => '',
            'group'               => [],
            'searchable'          => false,
            'search_result_field' => false,
            'classifiable'        => '',
            'permissible'         => false,
            'categorizable'       => false,
            'filter_widget'       => '',
            'filter_order'        => 1,
            'filter_category'     => '',
            'filter_query_mode'   =>  \Search::OPERATOR_OR,
            'reference_is_a_parent' => false,
        ];

        switch ($name) {
            case 'author':
                $saveField                      = true;
                $titleText                      = 'Author';
                $type                           = 'reference';
                $options['widget']              = 'autocomplete';
                $options['target']              = ['users'];
                $options['search_result_field'] = true;
                break;
            case 'title':
                $saveField                      = true;
                $titleText                      = 'Title';
                $type                           = 'text';
                $options['widget']              = 'text';
                $options['searchable']          = true;
                $options['search_result_field'] = true;
                break;
            case 'status':
                $saveField                      = true;
                $titleText                      = 'Status';
                $type                           = 'checkbox';
                $options['widget']              = 'onoff';
                $options['default']             = 1;
                $options['search_result_field'] = true;
                break;
            case 'created_at':
                $saveField                      = true;
                $titleText                      = 'Authored on';
                $type                           = 'timestamp';
                $options['widget']              = 'datetime';
                $options['search_result_field'] = true;
                break;
            case 'updated_at':
                $saveField                      = true;
                $titleText                      = 'Updated on';
                $type                           = 'timestamp';
                $options['widget']              = 'datetime';
                $options['search_result_field'] = true;
                break;
            case 'langcode':
                $saveField                      = true;
                $titleText                      = 'Language';
                $type                           = 'select';
                $options['widget']              = 'select';
                $options['default']             = \Drupal::languageManager()->getDefaultLanguage()->getId();
                $options['search_result_field'] = true;
                $options['allowed_values']      = [];

                // Save current language translator
                $currentLanguage = \Drupal::languageManager()->getCurrentLanguage();
                foreach ($this->languages as $language) {
                    $translator = \Drupal::languageManager()->getLanguage($language);

                    // Override current language with the one we want
                    \Drupal::languageManager()->setConfigOverrideLanguage($translator);
                    $availableLanguages = \Drupal::languageManager()->getLanguages();
                    foreach ($availableLanguages as $availableLanguage) {
                        $options['allowed_values'][$language][$availableLanguage->getId()] =
                            $availableLanguage->getName();
                    }
                }
                // Set back to current language translator
                \Drupal::languageManager()->setConfigOverrideLanguage($currentLanguage);
                break;
        }

        if ($saveField) {
            $title       = [];
            $description = [];

            foreach ($this->languages as $language) {
                $title[$language]       = (string)t($titleText, [], ['langcode' => $language]);
                $description[$language] = '';
            }

            $options['title']       = $title;
            $options['description'] = $description;

            $this->attachGroup($name, $options);

            $data = [
                'model'     => $model,
                'name'      => $name,
                'type'      => $type,
                'options'   => $options,
                'displayed' => !$isHidden,
            ];

            $this->createOrUpdateField($data);
        }
    }
}
