<?php

namespace Inside\Host\Helpers\Adapter\Form;

use Illuminate\Support\Str;

/**
 * Flatten formDisplay from Drupal 8
 *
 * @category Class
 * @package  Inside\Host\Adapter\Form\MenuLinkForm
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class MenuLinkForm extends BaseForm
{
    /**
     * {@inheritDoc}
     */
    protected const REMOVABLE_FIELD = [
        'translation',
        'view_mode',
        'description',
        'expanded',
        'id',
        'uuid',
        'bundle',
        'description',
        'menu_name',
        'external',
        'rediscover',
        'expanded',
        'parent',
        'default_langcode',
        'content_translation_source',
        'content_translation_outdated',
        'content_translation_uid',
        'content_translation_status',
        'content_translation_created',
    ];

    /**
     * {@inheritDoc}
     */
    protected const FIELD_NAME = [
        'enabled' => 'status',
    ];


    /**
     * {@inheritDoc}
     */
    protected function getModel(): string
    {
        $bundle = $this->bundle . '_menus';

        return 'Inside\Content\Models\Contents\\' . Str::studly($bundle);
    }


    /**
     * {@inheritDoc}
     */
    protected function handleAttributeFields(string $name, $field = null, bool $isHidden = false): void
    {
        $model     = $this->getModel();
        $saveField = false;
        $title     = '';
        $type      = 'text';
        $weight    = 0;

        if (is_array($field))
        {
            $weight = $field['weight'];
        }

        $options = [
            'cardinality'       => 1,
            'translatable'      => true,
            'required'          => true,
            'weight'            => $weight,
            'default'           => null,
            'widget'            => '',
            'group'             => [],
            'searchable'        => false,
        ];

        switch ($name)
        {
            case 'title':
                $saveField         = true;
                $titleText         = 'Title';
                $type              = 'text';
                $options['widget'] = 'text';
                break;
            case 'status':
                $saveField               = true;
                $titleText               = 'Status';
                $type                    = 'checkbox';
                $options['widget']       = 'onoff';
                $options['default']      = 1;
                $options['translatable'] = false;
                break;
            case 'weight':
                $saveField               = true;
                $titleText               = 'Weight';
                $type                    = 'integer';
                $options['widget']       = 'integer';
                $options['default']      = 0;
                $options['translatable'] = false;
                break;
            case 'link':
                $saveField               = true;
                $titleText               = 'Link';
                $type                    = 'link';
                $options['widget']       = 'link';
                $options['translatable'] = false;
                break;
            case 'langcode':
                $avalaibleLanguages = \Drupal::languageManager()->getLanguages();

                $saveField                 = true;
                $titleText                 = 'Language';
                $type                      = 'select';
                $options['widget']         = 'select';
                $options['default']        = \Drupal::languageManager()->getDefaultLanguage()->getId();
                $options['allowed_values'] = [];

                foreach ($avalaibleLanguages as $avalaibleLanguage)
                {
                    $options['allowed_values'][$avalaibleLanguage->getId()] = $avalaibleLanguage->getName();
                }
                break;
        }

        if ($saveField)
        {
            $title       = [];
            $description = [];

            foreach ($this->languages as $language)
            {
                $title[$language]       = (string) t($titleText);
                $description[$language] = '';
            }

            $options['title']       = $title;
            $options['description'] = $description;

            $this->attachGroup($name, $options);

            $data = [
                'model'     => $model,
                'name'      => $name,
                'type'      => $type,
                'options'   => $options,
                'displayed' => !$isHidden,
            ];

            $this->createOrUpdateField($data);
        }
    }
}
