<?php

namespace Inside\Host\Exodus\Services;

use Drupal;
use Illuminate\Support\Collection;

/**
 * This class is used to get the status of current content types.
 * It is used to find easly the content types that are searchable, aliasable, global searchable, permissible, categorizable, translatable.
 * Every method returns a new instance of the class, so it is possible to chain the methods and under the hood it automatically uses Collection.
 *
 * @mixin Collection
 */
final class ContentTypeStatusService
{
    /**
     * @var Collection<NodeType>
     */
    private Collection $source;

    public function __construct()
    {
        $this->source = app(DrupalContainer::class)->source();
    }

    /**
     * If the method does not exist on the class, pass the call to Illuminate Collection.
     *
     * @param $method
     * @param $parameters
     * @mixin Collection
     * @return mixed
     */
    public function __call($method, $parameters)
    {
       return $this->source->{$method}(...$parameters);
    }

    public function searchables(): self
    {
        $this->source = $this->source->where('third_party_settings.inside.searchable', true);

        return $this;
    }

    public function notSearchables():self
    {
        $this->source = $this->source->where('third_party_settings.inside.searchable', false);

        return $this;
    }

    public function aliasables(): self
    {
        $this->source = $this->source->where('third_party_settings.inside.aliasable', true);

        return $this;
    }

    public function notAliasables(): self
    {
        $this->source = $this->source->where('third_party_settings.inside.aliasable', false);

        return $this;
    }

    public function globalSearchables(): self
    {
        $this->source = $this->source->where('third_party_settings.inside.global_searchable', true);

        return $this;
    }

    public function notGlobalSearchables(): self
    {
        $this->source = $this->source->where('third_party_settings.inside.global_searchable', false);

        return $this;
    }

    public function permissibles(): self
    {
        $this->source = $this->source->where('third_party_settings.inside.permissible', true);

        return $this;
    }

    public function notPermissibles(): self
    {
        $this->source = $this->source->where('third_party_settings.inside.permissible', false);

        return $this;
    }

    public function categorizables(): self
    {
        $this->source = $this->source->where('third_party_settings.inside.categorizable', true);

        return $this;
    }

    public function notCategorizables(): self
    {
        $this->source = $this->source->where('third_party_settings.inside.categorizable', false);

        return $this;
    }

    public function translatables(): self
    {
        $this->source = $this->source->where('third_party_settings.inside.translatable', true);

        return $this;
    }

    public function notTranslatables(): self
    {
        $this->source = $this->source->where('third_party_settings.inside.translatable', false);

        return $this;
    }

    public function ofListingType(?string $type): self
    {
        $this->source = $this->source->where('third_party_settings.inside.listing_type', $type);

        return $this;
    }

    public function notOfListingType(?string $type): self
    {
        $this->source = $this->source->where('third_party_settings.inside.listing_type', '!=', $type);

        return $this;
    }
}
