<?php

namespace Inside\Host\Exodus\Enum;

use ReflectionClass;

abstract class BaseExtendedEnum
{
    protected array $extends = [];

    protected function __construct()
    {
        //
    }

    public static function all(): array
    {
        return array_merge(
            (new ReflectionClass(static::class))->getConstants(),
            static::class::extendedCases()
        );
    }

    public static function values(): array
    {
        return array_values(static::all());
    }

    public static function keys(): array
    {
        return array_keys(static::all());
    }

    public static function has(mixed $type): bool
    {
        return in_array(strtoupper($type), static::all());
    }

    protected static function extendedCases(): array
    {
        return [];
    }
}
