<?php

namespace Inside\Host\Exceptions;

use Exception;

/**
 * Field type is not supported exception.
 *
 * @category Class
 * @package  Inside\inside\Exceptions\UnsupportedFieldException
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class UnsupportedFieldException extends Exception
{
    /**
     *
     * @param string $type
     * @return \Inside\Host\Exceptions\UnsupportedFieldException
     */
    public static function named(string $type)
    {
        return new static("Field type `{$type}` is not supported.");
    }
}
