<?php

namespace Inside\Host\Exceptions;

use Exception;

/**
 * Table already exists exception.
 *
 * @category Class
 * @package  Inside\inside\Exceptions\TableAlreadyExistException
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class TableAlreadyExistException extends Exception
{

    /**
     * @param string $type
     * @return \Inside\Host\Exceptions\TableAlreadyExistException
     */
    public static function named(string $type)
    {
        return new static("Content `{$type}` already exists.");
    }
}
