<?php

namespace Inside\Host\Exceptions;

use Exception;

/**
 * Column not found exception.
 *
 * @category Class
 * @package  Inside\inside\Exceptions\ColumnNotFoundException
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class ColumnNotFoundException extends Exception
{
    /**
     *
     * @param string $type
     * @param string $name
     * @return \Inside\Host\Exceptions\ColumnNotFoundException
     */
    public static function named(string $type, string $name)
    {
        return new static("Field `{$name}` not found in content type `{$type}`.");
    }
}
