<?php

namespace Inside\Host\Exceptions;

use Exception;

/**
 * Column already exists exception.
 *
 * @category Class
 * @package  Inside\inside\Exceptions\ColumnAlreadyExistsException
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class ColumnAlreadyExistsException extends Exception
{
    /**
     *
     * @param string $type
     * @param string $name
     * @return \Inside\Host\Exceptions\ColumnAlreadyExistsException
     */
    public static function named(string $type, string $name)
    {
        return new static("Field `{$name}` already exist in content type `{$type}`.");
    }
}
