<?php

namespace Inside\Host\EventSubscriber\EntityType;

use Schema;
use Illuminate\Database\Schema\Blueprint;
use Inside\Host\Event\EntityType\ParagraphType\ParagraphTypeInsertEvent;
use Inside\Host\Event\EntityType\ParagraphType\ParagraphTypeUpdateEvent;
use Inside\Host\Event\EntityType\ParagraphType\ParagraphTypeDeleteEvent;
use Inside\Host\EventSubscriber\EntityType\BaseEntityTypeEventSubscriber;

/**
 * Define paragraph type events triggered in Drupal 8
 *
 * @category Class
 * @package  Inside\Host\EventSubscriber\ParagraphType\ParagraphTypeEventSubscriber
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class ParagraphTypeEventSubscriber extends BaseEntityTypeEventSubscriber
{
    /**
     * {@inheritDoc}
     */
    const TABLE_PREFIX = 'inside_section_';

    /**
     * {@inheritDoc}
     */
    const NAMESPACE_PREFIX = 'Inside\Content\Models\Sections\\';

    /**
     * {@inheritdoc}
     */
    public static function getSubscribedEvents()
    {
        $events[ParagraphTypeInsertEvent::INSERT][] = ['insert'];
        $events[ParagraphTypeUpdateEvent::UPDATE][] = ['update'];
        $events[ParagraphTypeDeleteEvent::DELETE][] = ['delete'];

        return $events;
    }

    /**
     * {@inheritDoc}
     */
    protected function createTable(): void
    {
        Schema::create($this->table, function (Blueprint $table) {
            $table->uuid('uuid')->collate('utf8');
            $table->uuid('uuid_host')->collate('utf8');
            $table->tinyInteger('status')->default(0);
            $table->char('langcode', 2)->nullable();
            $table->uuid('author')->collate('utf8')->nullable();
            $table->uuid('author_id')->comment('Author uuid');
            $table->uuid('update_author')->collate('utf8')->nullable();
            $table->uuid('sectionable_uuid')->collate('utf8')->nullable();
            $table->string('sectionable_type', 255);
            $table->string('field', 255);
            $table->integer('weight');
            $table->timestamps();

            $table->primary('uuid');
            $table->index('langcode');
            $table->index(['sectionable_type', 'sectionable_uuid', 'field'], 'section_identifier_index');
            $table->index(['uuid', 'langcode']);

            $table->foreign('author')->references('uuid')->on('inside_content_users');
            $table->foreign('author_id')->references('uuid')->on('inside_users');
            $table->foreign('update_author')->references('uuid')->on('inside_content_users');
        });
    }
}
