<?php

namespace Inside\Host\EventSubscriber\EntityType;

use Schema;
use Illuminate\Database\Schema\Blueprint;
use Inside\Host\Event\EntityType\Menu\MenuInsertEvent;
use Inside\Host\Event\EntityType\Menu\MenuUpdateEvent;
use Inside\Host\Event\EntityType\Menu\MenuDeleteEvent;
use Inside\Host\EventSubscriber\EntityType\BaseEntityTypeEventSubscriber;

/**
 * Define node type events triggered in Drupal 8
 *
 * @category Class
 * @package  Inside\Host\EventSubscriber\Menu\MenuEventSubscriber
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class MenuEventSubscriber extends BaseEntityTypeEventSubscriber
{
    /**
     * {@inheritDoc}
     */
    const TABLE_SUFFIX = '_menus';

    /**
     * SUFFIX CLASS
     *
     * @var const
     */
    const CLASS_SUFFIX = 'Menus';

    /**
     * {@inheritDoc}
     */
    const RESERVED_NAME = [
        'menus',
        'users'
    ];

    /**
     * {@inheritdoc}
     */
    public static function getSubscribedEvents()
    {
        $events[MenuInsertEvent::INSERT][] = ['insert'];
        $events[MenuUpdateEvent::UPDATE][] = ['update'];
        $events[MenuDeleteEvent::DELETE][] = ['delete'];

        return $events;
    }

    /**
     * {@inheritDoc}
     */
    protected function createTable(): void
    {
        Schema::create($this->table, function (Blueprint $table) {
            $table->uuid('uuid')->collate('utf8');
            $table->uuid('uuid_host')->collate('utf8');
            $table->tinyInteger('status')->default(0);
            $table->uuid('author')->collate('utf8')->nullable();
            $table->uuid('author_id');
            $table->string('title', 255)->nullable();
            $table->string('link', 255);
            $table->uuid('update_author')->collate('utf8')->nullable();
            $table->integer('weight')->default(0);
            $table->uuid('pid')->collate('utf8')->nullable();
            $table->char('langcode', 2)->nullable();
            $table->timestamps();

            $table->primary('uuid');
            $table->index('status');
            $table->index('uuid');
            $table->index('pid');
            $table->index(['uuid', 'langcode']);
        });
    }
}
