<?php
declare(strict_types=1);

namespace Inside\Host\EventSubscriber\Entity;

use Drupal;
use Drupal\paragraphs\Entity\Paragraph;
use Inside\Host\Event\Entity\Paragraph\ParagraphInsertEvent;
use Inside\Host\Event\Entity\Paragraph\ParagraphUpdateEvent;
use Inside\Host\Event\Entity\Paragraph\ParagraphDeleteEvent;

/**
 * Define paragraph events triggered in Drupal 8
 *
 * @category Class
 * @package  Inside\Host\EventSubscriber\Paragraph\ParagraphEventSubscriber
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
final class ParagraphEventSubscriber extends BaseEntityEventSubscriber
{
    protected const ENTITY_TYPE = 'paragraph';

    public static function getSubscribedEvents(): array
    {
        $events[ParagraphInsertEvent::INSERT][] = ['process'];
        $events[ParagraphUpdateEvent::UPDATE][] = ['process'];
        $events[ParagraphDeleteEvent::DELETE][] = ['process'];

        return $events;
    }

    /**
     * Set paragraph weight
     */
    protected function setParagraphWeight(&$data, $entity)
    {
        $parent = $entity->getParentEntity();
        $fields = Drupal::service('entity_field.manager')->getFieldDefinitions($parent->getEntityTypeId(), $parent->getType());

        foreach ($fields as $field) {
            if ($field->getType() == 'entity_reference_revisions') {
                $values = $parent->get($field->getName())->getValue();

                foreach ($values as $index => $value) {
                    $paragraph = Paragraph::load($value['target_id']);

                    if ($paragraph?->uuid() == $data['uuid_host']) {
                        $data['weight'] = $index;
                        return;
                    }
                }
            }
        }
    }
}
