<?php
declare(strict_types=1);

namespace Inside\Host\EventSubscriber\Entity;

use Inside\Host\Event\Entity\Node\NodeInsertedEvent;
use Inside\Host\Event\Entity\Node\NodeInsertEvent;
use Inside\Host\Event\Entity\Node\NodeUpdateEvent;
use Inside\Host\Event\Entity\Node\NodeDeleteEvent;

/**
 * Define node events triggered in Drupal 8
 *
 * @category Class
 * @package  Inside\Host\EventSubscriber\Node\NodeEventSubscriber
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
final class NodeEventSubscriber extends BaseEntityEventSubscriber
{
    protected const ENTITY_TYPE = 'node';

    public static function getSubscribedEvents(): array
    {
        $events[NodeInsertEvent::INSERT][]     = ['process'];
        $events[NodeInsertEvent::INSERT][]     = ['processed'];
        $events[NodeInsertedEvent::INSERTED][] = ['inserted'];
        $events[NodeUpdateEvent::UPDATE][]     = ['process'];
        $events[NodeInsertEvent::UPDATE][]     = ['processed'];
        $events[NodeDeleteEvent::DELETE][]     = ['deleteTranslations'];
        $events[NodeDeleteEvent::DELETE][]     = ['process'];

        return $events;
    }
}
