<?php
declare(strict_types=1);

namespace Inside\Host\Event;

use Symfony\Contracts\EventDispatcher\Event;

/**
 * Base user event
 *
 * @category Class
 * @package  Inside\Host\Event\User\BaseUserEvent
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
abstract class BaseEvent extends Event
{
    /**
     * Get the action type
     *
     * @var string
     */
    protected const ACTION = null;

    /**
     * Insert action name
     *
     * @var string
     */
    public const INSERT = null;

    /**
     * Update action name
     *
     * @var string
     */
    public const UPDATE = null;

    /**
     * Delete action name
     *
     * @var string
     */
    public const DELETE = null;

    /**
     * The item.
     *
     * @var mixed
     */
    protected $item;

    /**
     * BaseEvent constructor.
     *
     * @param mixed $item
     */
    public function __construct($item)
    {
        $this->item = $item;
    }

    /**
     * Get the item.
     *
     * @return mixed
     */
    public function getItem()
    {
        return $this->item;
    }

    /**
     * Get the action type.
     *
     * @return mixed
     */
    public function getAction()
    {
        return static::ACTION;
    }
}
