<?php

namespace Inside\Host\Controller;

use Drupal\Component\Utility\Xss;
use Drupal\Core\Controller\ControllerBase;
use Inside\Host\Commands\InsideDrushCommands;

/**
 * Controller routines for update routes.
 */
class InsideDrupalController extends ControllerBase {

  /**
   * {@inheritdoc}
   */
  public function runCommands() {
    $parameters = \Drupal::request()->query->all();
    $path       = trim(Xss::filter($parameters['path'] ?? ''));
    $build = [
      '#title'  => '',
      'form' => $this->formBuilder()->getForm('\Inside\Host\Form\InsideDrushForm', $path),
    ];
    return $build;
  }

}
