<?php

namespace Inside\Host\Services;

use Drupal;
use Drupal\Core\DrupalKernel;
use Exception;
use Symfony\Component\HttpFoundation\Request;

/**
 * Drupal Service
 *
 * @category Class
 * @package  Inside\Host\Services\DrupalService
 * @author   Maecia <technique@maecia.com>
 * @link     http://www.maecia.com/
 */
class DrupalService
{

    /**
     * Create a new Drupal service instance
     *
     * @throws Exception
     */
    public function __construct(bool $full = true)
    {
        try {
            // Try to get Container, if drupal is not set, we'll catch Exception

            Drupal::getContainer();

            // No exception thrown, we already got a Drupal container booted and ready
        } catch (Exception $e) {
            // Load drupal and boot it
            $autoloader   = require __DIR__ . '/../../../../../vendor/autoload.php';
            $request      = Request::createFromGlobals();
            $drupalKernel = DrupalKernel::createFromRequest($request, $autoloader, 'prod', false, cms_base_path());
            if ($full) {
                $drupalKernel->handle($request);

                return;
            }
            $drupalKernel->boot();
            $drupalKernel->preHandle($request);

            if (PHP_SAPI === 'cli') {
                return;
            }

            $session = $drupalKernel->getContainer()->get('session');
            $session->start();
            $request->setSession($session);

            $user = $drupalKernel->getContainer()->get('user.authentication.cookie')->authenticate($request);
            if (!$user) {
                $drupalKernel->handle($request);

                return;
            }
            $drupalKernel->getContainer()->get('current_user')->setAccount($user);
        }
    }
}
