<?php

namespace Drupal\inside\Plugin\Field\FieldWidget;

use Drupal\Core\Datetime\DrupalDateTime;
use Drupal\Core\Datetime\Plugin\Field\FieldWidget\TimestampDatetimeWidget;
use Drupal\Core\Form\FormStateInterface;

/**
 * Plugin implementation of the 'inside_timestamp_field_widget' widget.
 *
 * @FieldWidget(
 *   id = "inside_timestamp_field_widget",
 *   module = "inside",
 *   label = @Translation("Inside timestamp field widget"),
 *   field_types = {
 *     "timestamp"
 *   }
 * )
 */
class InsideTimestampFieldWidget extends TimestampDatetimeWidget
{
    public function massageFormValues(array $values, array $form, FormStateInterface $form_state)
    {
        foreach ($values as &$item) {
            if (isset($item['value']) && $item['value'] instanceof DrupalDateTime) {
                $date = $item['value'];
            } elseif (isset($item['value']['object']) && $item['value']['object'] instanceof DrupalDateTime) {
                $date = $item['value']['object'];
            } else {
                $date = null;
            }
            $item['value'] = ($date !== null) ? $date->getTimestamp() : null;
        }

        return $values;
    }
}
